#if 0
#elif defined(__arm64__) && __arm64__
// Generated by Apple Swift version 6.1.2 effective-5.10 (swiftlang-6.1.2.1.2 clang-1700.0.13.5)
#ifndef AMAZONIVSCHATMESSAGING_SWIFT_H
#define AMAZONIVSCHATMESSAGING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="AmazonIVSChatMessaging",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

@class NSString;
enum AmazonIVSChatErrorCode : NSInteger;
/// Error messages are pushed to clients if an operation fails.
/// Due to the asynchronous nature of the Chat messaging API, web socket error messages include an
/// identifier that the client can use to map back to the responsible operation. The SDK already
/// handles this for you and throws these errors matched to the <code>ChatRequest/requestId</code> of the
/// attempted <code>ChatRequest</code> sent to an instance of <code>ChatRoom</code> through the
/// <code>ChatRoom/perform(request:)</code> function.
/// See <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/error-messages.html">our documentation</a>
/// for more info on different error types that could be thrown by the SDK.
SWIFT_CLASS_NAMED("ChatError")
@interface AmazonIVSChatError : NSObject
/// The server id of the error object.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object that triggered this error.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The error code of this chat error. Each error code is unique and can be used to identify
/// why the request failed. See <code>ChatError/Code</code> for more information on the different codes
/// that can be thrown.
@property (nonatomic, readonly) enum AmazonIVSChatErrorCode errorCode;
/// The message content of the chat error. This content may be populated by the Messaging API
/// itself or the SDK.
@property (nonatomic, readonly, copy) NSString * _Nullable errorMessage;
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, AmazonIVSChatErrorCode, "Code", closed) {
/// The request is either malformed, invalid, or the chat message exceeded the character limit (invalid).
  AmazonIVSChatErrorCodeInvalidParameter = 400,
/// The connection has expired.
  AmazonIVSChatErrorCodeUnauthorized = 401,
/// The connection’s capabilities do not permit this action.
  AmazonIVSChatErrorCodeForbidden = 403,
/// Either the room could not be found or a resource referenced/mutated by the operation does not exist.
  AmazonIVSChatErrorCodeResourceNotFound = 404,
/// The request was rejected during message review.
  AmazonIVSChatErrorCodeNotAcceptable = 406,
/// The request contains fields that are too large.
  AmazonIVSChatErrorCodePayloadTooLarge = 413,
/// The application has exceeded rate limits.
  AmazonIVSChatErrorCodeTooManyRequests = 429,
/// Unknown error.
  AmazonIVSChatErrorCodeInternalServerError = 500,
};

@class NSDate;
/// An event broadcasted to the chat room through the Messaging API.
SWIFT_CLASS_NAMED("ChatEvent")
@interface AmazonIVSChatEvent : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull eventName;
/// The server id of the event object broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object that triggered this event in a chat room.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The timestamp of when the event was broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSDate * _Nonnull sendTime;
/// Custom metadata that is supplied by the request object that triggered this event.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
@end

@class AmazonIVSChatUser;
/// A message sent by a user that is connected to the chat room.
SWIFT_CLASS_NAMED("ChatMessage")
@interface AmazonIVSChatMessage : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull content;
@property (nonatomic, readonly, strong) AmazonIVSChatUser * _Nonnull sender;
/// The server id of a message.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object used to send this message to a chat room.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The timestamp of when the message was broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSDate * _Nonnull sendTime;
/// Custom metadata that you supply through the <code>attributes</code> parameter of the
/// <code>SendMessageRequest/init(content:attributes:)</code> initializer for <code>SendMessageRequest</code>.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
@end

@protocol AmazonIVSChatRoomDelegate;
enum AmazonIVSChatRoomState : NSInteger;
@protocol AmazonIVSChatTokenProvider;
@class AmazonIVSChatSendMessageRequest;
@class AmazonIVSChatDeleteMessageRequest;
@class AmazonIVSChatDeletedMessage;
@class AmazonIVSChatDisconnectUserRequest;
@class AmazonIVSChatDisconnectedUser;
/// The representation of an Amazon IVS Chat Room that provides the same functionality that a
/// developer can achieve using the IVS Chat Messaging APIs.
SWIFT_CLASS_NAMED("ChatRoom")
@interface AmazonIVSChatRoom : NSObject
/// The object that acts as the delegate for a <code>ChatRoom</code>.
/// This is the property you want to set if you want to get notifications for events that
/// occur in a chat room (such as messages received or users that were disconnected by another
/// user).
@property (nonatomic, weak) id <AmazonIVSChatRoomDelegate> _Nullable delegate;
/// An observable value that represents the active state of a <code>ChatRoom</code>’s connection.
/// The <code>ChatRoom/state-swift.property</code> property uses Combine’s <code>@Published</code> property wrapper
/// to transmit changes to its value over time. Using Combine, you can observe changes to this
/// property to update your UI accordingly.
/// Below is an example of updating a <code>UIButton</code> that you might use to send messages from a
/// chat room message bar:
/// \code
/// let button = UIButton()
/// let room = ChatRoom(...)
///
/// room.$state.sink { state in
///     switch state {
///     case .connecting, .disconnected:
///         button.isEnabled = false
///     case .connected:
///         button.isEnabled = true
///     }
/// }
///
/// \endcode
@property (nonatomic, readonly) enum AmazonIVSChatRoomState state;
/// Creates an instance of <code>ChatRoom</code> with a <code>tokenProvider</code> that uses delegation to retrieve
/// chat tokens.
/// Since your mobile application is responsible for generating/requesting chat tokens from your
/// backend, this initializer gives you a way to supply the chat token response from your
/// backend to the Chat SDK.
/// \code
/// class MyBackendService: ChatTokenProvider {
///     func getChatToken() async throws -> ChatToken {
///         // call your backend and return a ChatToken here
///         let url = URL(string: "https://api.yourcompany.com/get-chat-token")!
///         var request = URLRequest(url: url)
///         request.httpMethod = "POST"
///         request.httpBody = try JSONEncoder().encode([
///             "userId" : "kraken",
///             "otherParameter" : "some-value"
///         ])
///
///         // Make the request to your backend server app
///         let data = try await URLSession.shared.data(for: request).0
///
///         // Decode the `ChatToken` object from the response of the url request.
///         return try JSONDecoder().decode(ChatToken.self, from: data)
///     }
/// }
///
/// // This is probably something like "us-west-2" or "us-east-1"
/// let awsRegion: String = getAwsRegion()
/// let room = try await ChatRoom(
///     awsRegion: awsRegion,
///     tokenProvider: MyBackendService()
/// )
/// print("💬 Room is connecting!")
/// try await room.connect()
/// print("✅ Room connected!")
///
/// \endcode\param awsRegion The AWS region that your chat room was created in. This might be a single aws
/// region that your backend application creates all chat rooms in, or it might be a dynamic
/// AWS region if your server-side application creates rooms in more than one region.
///
/// \param maxReconnectAttempts An integer representing the maximum amount of times this <code>ChatRoom</code>
/// instance will attempt to reconnect to the socket when something happens that requires a
/// refresh of your <code>ChatToken</code>. The current amount of connect attempts will reset when a
/// successful <code>room.connect()</code> call occurs.
///
/// \param tokenProvider An asynchronous, escaping closure that can be called more than once when
/// the <code>ChatRoom</code> needs a new chat token from your mobile application’s backend. If your
/// mobile application uses Swift’s async/await APIs you can call <code>try await</code> within this
/// closure.
///
- (nonnull instancetype)initWithAwsRegion:(NSString * _Nonnull)awsRegion maxReconnectAttempts:(NSInteger)maxReconnectAttempts tokenProvider:(id <AmazonIVSChatTokenProvider> _Nonnull)tokenProvider;
/// A Swift Async function that attempts to establish a connection with a chat room.
/// To get a valid chat token, the SDK will attempt to call the token provider that you used to
/// initialize this chat room. Once the token fetch has succeeded, it will then use that chat
/// token to authenticate to IVS’ Chat Messaging API by means of opening a web socket.
///
/// throws:
/// The same <code>Swift.Error</code> that your <code>ChatTokenProvider</code> throws during
/// <code>ChatTokenProvider/getChatToken()</code>.
- (void)connectWithCompletionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
/// Connects to the chat room, sending a notification of successes or failures in a
/// completion handler.
/// This is functionally equivalent to <code>ChatRoom/connect()</code>. Any errors thrown by that
/// function will be returned as a parameter within the completion handler. If the error is nil,
/// you can assume a successful connection to the chat room.
/// The completion handler passes in the current instance of <code>ChatRoom</code> to assist with follow
/// up actions that you may want to perform on a <code>ChatRoom</code> without having to deal with
/// reference semantics in the context of memory management within the closure’s capture list.
/// \param completion A closure that passes in the current <code>ChatRoom</code> instance with an optional
/// <code>Swift.Error</code> that is populated when the connection fails. The error parameter is nil
/// when connecting successfully.
///
- (void)connect:(void (^ _Nonnull)(AmazonIVSChatRoom * _Nonnull, NSError * _Nullable))completion;
/// Disconnects from the chat room.
/// Calling this function will tear down any currently connected <code>URLSession</code>s or data tasks
/// associated with the room. If the <code>ChatToken</code> you used to authenticate to the chat room
/// has session expiration metadata associated with it, this function will also cancel the
/// internal timer that <code>ChatRoom</code> creates to proactively refresh your token before it
/// expires.
- (void)disconnect;
/// Sends a message to the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>SendMessageRequest</code>s only.
/// \param request An instance of <code>SendMessageRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>ChatMessage</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)sendMessageWithRequest:(AmazonIVSChatSendMessageRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatMessage * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
/// Deletes a message from the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>DeleteMessageRequest</code>s only.
/// \param request An instance of <code>DeleteMessageRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>DeletedMessage</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)deleteMessageWithRequest:(AmazonIVSChatDeleteMessageRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatDeletedMessage * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
/// Disconnects a user from the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>DisconnectUserRequest</code>s only.
/// \param request An instance of <code>DisconnectUserRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>DisconnectedUser</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)disconnectUserWithRequest:(AmazonIVSChatDisconnectUserRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatDisconnectedUser * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The active state of a <code>ChatRoom</code>’s connection.
typedef SWIFT_ENUM_NAMED(NSInteger, AmazonIVSChatRoomState, "State", closed) {
/// Indicates when a room is connecting to a web socket. Only used during the transition
/// from <code>.disconnected</code> to <code>.connected</code>. This is not set when there is an active
/// connection in a room.
  AmazonIVSChatRoomStateConnecting = 0,
/// Indicates that a room is ready to receive and send messages.
  AmazonIVSChatRoomStateConnected = 1,
/// Indicates that a room is no longer capable of receiving or sending messages.
  AmazonIVSChatRoomStateDisconnected = 2,
};

/// A type that provides hooks into events that occur within a <code>ChatRoom</code> (such as receiving
/// messages or changes to a room’s connection state).
/// To get notified when events within a <code>AmazonIVSChatMessaging/ChatRoom</code> occur, you need to
/// define your own type that conforms to this protocol and implement
/// <code>AmazonIVSChatMessaging/ChatRoomDelegate/room(_:didReceive:)-4zyws</code>:
/// \code
/// import AmazonIVSChatMessaging
/// struct YourChatManager: ChatRoomDelegate {
///     func room(_ room: ChatRoom, didReceive message: ChatMessage) {
///         // Prints the contents of a message that someone sent to this Chat Room
///         print(message.content)
///     }
/// }
///
/// \endcodeAfter you’ve defined a type that conforms to <code>AmazonIVSChatMessaging/ChatRoomDelegate</code>,
/// create an instance of that type and assign it to the <code>AmazonIVSChatMessaging/ChatRoom/delegate</code>
/// property of a <code>AmazonIVSChatMessaging/ChatRoom</code>. This follows the same delegation pattern of
/// common UIKit classes such as <code>UITableView</code> or <code>UIScrollView</code>.
/// \code
/// let delegate = YourChatManager()
/// let room = ChatRoom(...)
///
/// // Assign your delegate before connecting to the room
/// room.delegate = delegate
///
/// // Connect to the chat room to start receiving events
/// try await room.connect()
///
/// \endcode
SWIFT_PROTOCOL_NAMED("ChatRoomDelegate")
@protocol AmazonIVSChatRoomDelegate
/// Notifies when a message is received in a chat room.
/// This is the only function required by <code>ChatRoomDelegate</code> when conforming to it. It is
/// typically called when the chat room’s web socket receives a JSON payload that maps directly
/// to the properties found in <code>ChatMessage</code>. This is specifically determined by the value of
/// the “type” field in that JSON payload - the value in this case would be “MESSAGE”.
/// \param room The instance of the room that this message was received in.
///
/// \param message The message that was received.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didReceiveMessage:(AmazonIVSChatMessage * _Nonnull)message;
@optional
/// Notifies when special events (such as system events or custom client-defined events) are
/// received by a chat room.
/// This function is typically called when the chat room’s web socket receives a JSON payload
/// that maps directly to the properties found in <code>ChatEvent</code>. This is specifically determined
/// by the value of the “type” field in that JSON payload - the value in this case would be “EVENT”.
/// IVS Chat also defines system events for common actions that occur in a chat room such as
/// messages being deleted or users that get disconnected by a moderator in the room. These
/// system events can be identified by inspecting the event’s <code>ChatEvent/eventName</code> property.
/// All system events sent by IVS will prefix the <code>ChatEvent/eventName</code> value with “aws:”.
/// \param room The instance of the room that this event was received in.
///
/// \param event The event that was received.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didReceiveEvent:(AmazonIVSChatEvent * _Nonnull)event;
/// A system event defined by IVS Chat that represents when a message is deleted by a user
/// in a chat room.
/// When a chat room receives this system event, a specialized payload gets attached to the
/// <code>ChatEvent/attributes</code> property of an underlying <code>ChatEvent</code> instance. The SDK then
/// serializes that payload into an instance of <code>DeletedMessage</code> and passes it into
/// this function. If this serialization fails, the SDK has a fallback that will call the
/// <code>ChatRoomDelegate/room(_:didReceive:)-4zyws</code> function instead.
/// \param room The instance of the room this message was deleted in.
///
/// \param message A class that contains the id of the deleted message as well as the reason for
/// that message getting deleted.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didDeleteMessage:(AmazonIVSChatDeletedMessage * _Nonnull)message;
/// A system event defined by IVS Chat that represents when a user is disconnected by another
/// user (typically a moderator) in a chat room.
/// When a chat room receives this system event, a specialized payload gets attached to the
/// <code>ChatEvent/attributes</code> property of an underlying <code>ChatEvent</code> instance. The SDK then
/// serializes that payload into an instance of <code>DisconnectedUser</code> and passes it into
/// this function. If this serialization fails, the SDK has a fallback that will call the
/// <code>ChatRoomDelegate/room(_:didReceive:)-4zyws</code> function instead.
/// \param room The instance of the room this user was disconnected from.
///
/// \param user A class that contains the id of the disconnected user as well as the reason for
/// that user getting disconnected (typically due to some sort of moderation action).
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didDisconnectUser:(AmazonIVSChatDisconnectedUser * _Nonnull)user;
/// A lifecycle event that represents when a <code>ChatRoom</code> has successfully connected and can
/// receive/send messages.
/// Calling <code>ChatRoom/connect()</code> on a <code>ChatRoom</code> instance does not automatically call this
/// function. The room waits for a successful web socket connection before determining whether
/// or not it has been connected. You can assume that this callback will only occur when you can
/// successfully start sending requests to a chat room.
/// \param room The instance of the room that successfully connected.
///
- (void)roomDidConnect:(AmazonIVSChatRoom * _Nonnull)room;
/// A lifecycle event that represents when a fully disconnected <code>ChatRoom</code> is attempting to
/// connect.
/// Calling <code>ChatRoom/connect()</code> on a <code>ChatRoom</code> instance does not automatically call this
/// function. A <code>ChatToken</code> may still be valid for a chat room when calling
/// <code>ChatRoom/connect()</code> which means your room may still be connected. This callback should
/// only occur when a room is completely disconnected and not capable of receiving or
/// sending messages.
/// \param room The instance of the room that is currently connecting.
///
- (void)roomIsConnecting:(AmazonIVSChatRoom * _Nonnull)room;
/// A lifecycle event that represents when a <code>ChatRoom</code> is no longer able to receive or send
/// messages.
/// Calling <code>ChatRoom/disconnect()</code> on a <code>ChatRoom</code> instance will automatically call this
/// function after making tear down calls to the underlying <code>URLSession</code>. This callback will
/// only occur when a room is either currently connected or trying to connect to the underlying
/// web socket and the user calls <code>ChatRoom/disconnect()</code>.
/// \param room The instance of the room that is currently connecting.
///
- (void)roomDidDisconnect:(AmazonIVSChatRoom * _Nonnull)room;
@end

/// A representation of the <code>CreateChatToken</code> response payload from the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/Welcome.html">AWS IVS Chat API
/// </a>.
/// By default, all you need is the token string returned by your server-side application to
/// effectively initialize an instance of <code>ChatRoom</code>. However, you can provide additional
/// information (also provided by your backend) that instances of <code>ChatRoom</code> use to provide sensible
/// default behavior throughout the course of your chat session.
/// The order in which token authentication occurs is as follows:
/// <ol>
///   <li>
///     Your chat app makes a URL request to your server-side application to initiate the
///     token creation flow. This is typically done through an object that conforms to
///     <code>ChatTokenProvider</code> within the body of the <code>ChatTokenProvider/getChatToken()</code> function.
///   </li>
///   <li>
///     Your server-side application then makes a POST request to the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken endpoint
///     </a>
///     from the IVS Chat Control Plane API.
///   </li>
///   <li>
///     Using the response from the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken endpoint
///     </a>, your
///     server-side application will then forward that payload in its response to your chat app. Your
///     chat app will use this payload to create an instance of <code>ChatToken</code> and return that token
///     instance in its implementation of <code>ChatTokenProvider/getChatToken()</code>.
///   </li>
///   <li>
///     An instance of <code>ChatRoom</code> will then use that <code>ChatTokenProvider</code> to query for chat tokens
///     at the appropriate times (such as when your session is about to expire or when the room needs
///     to connect for the first time).
///   </li>
/// </ol>
SWIFT_CLASS_NAMED("ChatToken")
@interface AmazonIVSChatToken : NSObject
/// Creates an instance of <code>ChatToken</code>
/// \param token The encrypted token string returned by your server-side application.
///
/// \param tokenExpirationTime The date by which the token should be used to authenticate to a
/// chat room.
///
/// \param sessionExpirationTime The date by which the token should be refreshed by the chat
/// room. This is when your chat session will expire.
///
- (nonnull instancetype)initWithToken:(NSString * _Nonnull)token tokenExpirationTime:(NSDate * _Nullable)tokenExpirationTime sessionExpirationTime:(NSDate * _Nullable)sessionExpirationTime OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A type that provides a chat token that can be used to successfully authenticate to a chat room.
/// Chat token providers are how your <code>ChatRoom</code> instances delegate the retrieval of encrypted
/// chat tokens from your server-side application. Your chat app is responsible for assigning
/// a provider to a chat room through its initializers.
SWIFT_PROTOCOL_NAMED("ChatTokenProvider")
@protocol AmazonIVSChatTokenProvider
/// Queries your server-side application for a chat token when an instance of <code>ChatRoom</code>
/// requires authentication.
///
/// returns:
/// An instance of a <code>ChatToken</code> that is used to authenticate to our Messaging API.
/// This token provides the encrypted token value as well as additional information that
/// <code>ChatRoom</code> instances can use to gracefully refresh a chat session before it expires.
- (void)getChatTokenWithCompletionHandler:(void (^ _Nonnull)(AmazonIVSChatToken * _Nullable, NSError * _Nullable))completionHandler;
@end

/// The representation of a user in the chat room.
/// This is typically deserialized from the <code>ChatMessage/sender</code> property of a
/// <code>ChatMessage</code> received by the chat room.
SWIFT_CLASS_NAMED("ChatUser")
@interface AmazonIVSChatUser : NSObject
/// A unique identifier for this user. This is typically the value needed for initializing a
/// valid <code>DisconnectUserRequest</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull userId;
/// Metadata that directly correlates to the data passed by your server application when making
/// calls to the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken API</a>.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
/// A property that provides conformance to the <code>Identifiable</code> protocol. The underlying value
/// is the same as the value for <code>ChatUser/userId</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A type used to delete an existing message from a chat room.
SWIFT_CLASS_NAMED("DeleteMessageRequest")
@interface AmazonIVSChatDeleteMessageRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>DeleteMessageRequest</code>.
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatEvent</code> being broadcasted to all users currently connected to
/// the chat room. This event is parsed and converted into a <code>DeletedMessage</code> instance
/// that gets sent through the <code>ChatRoomDelegate/room(_:didDelete:)</code> function within your
/// <code>ChatRoomDelegate</code>.
/// \param id The server id of the <code>ChatMessage</code> you want to delete.
///
/// \param reason A <code>String</code> used to indicate the reason for deleting this message. You can
/// leverage this value in your UI to notify your users why a specific message was deleted.
///
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id reason:(NSString * _Nullable)reason OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A lightweight representation of a <code>ChatMessage</code> that was deleted by a moderator in a chat
/// room.
/// The Messaging SDK will not make any assumptions about how you persist the data you receive from
/// a chat room. By providing a lightweight representation of the affected object, you get the
/// flexibility of choosing a data storage implementation that works best for your app (e.g.
/// CoreData or Realm) and can use the <code>DeletedMessage/messageID</code> property to aid in lookups.
SWIFT_CLASS_NAMED("DeletedMessage")
@interface AmazonIVSChatDeletedMessage : NSObject
/// A unique identifier that matches the <code>id</code> value of a <code>ChatMessage</code> instance that was
/// previously received by a <code>ChatRoom</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull messageID;
/// The request id of the <code>DeleteMessageRequest</code> that was used to delete the message
/// associated with <code>DeletedMessage/messageID</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// The reason supplied by the moderator when deleting this message.
@property (nonatomic, readonly, copy) NSString * _Nullable reason;
@end

/// A type used to disconnect another user from a chat room.
SWIFT_CLASS_NAMED("DisconnectUserRequest")
@interface AmazonIVSChatDisconnectUserRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>DisconnectUserRequest</code>.
/// This request is solely meant to sever the web socket connection of another connected user.
/// If you are trying to implement a ban-like feature in your chat app, you need to make sure
/// that you persist that user as “banned” within your server-side application. If you don’t do
/// this, a disconnected user can easily reconnect to the chat room by requesting another token
/// from that same server-side application.
/// The Amazon IVS Messaging API is a stateless API, therefore it does not keep track of user
/// state on your behalf. Most clients will already have a concept of an identity system within
/// their own server-side applications, so the Messaging API relies on your server-side app to
/// manage authentication through a token-based authentication system (refer to the reference
/// documentation for <code>ChatToken</code> for more information).
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatEvent</code> being broadcasted to all users currently connected to
/// the chat room (including the user being disconnected). This event is parsed and converted
/// into a <code>DisconnectedUser</code> instance that gets sent through the
/// <code>ChatRoomDelegate/room(_:didDisconnect:)</code> function within your <code>ChatRoomDelegate</code>.
/// \param id The server id of the <code>ChatMessage/sender</code> model that is attached to an instance
/// of a <code>ChatMessage</code> that was previously sent to a chat room.
///
/// \param reason A <code>String</code> used to indicate the reason for disconnecting this user. You can
/// leverage this value in your UI to notify your users why a specific user was disconnected.
/// A common use case might be to show other users why another user was banned from a room.
///
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id reason:(NSString * _Nullable)reason OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A lightweight representation of a <code>ChatUser</code> that was disconnected by a moderator in a chat
/// room.
/// The Messaging SDK will not make any assumptions about how you persist the data you receive from
/// a chat room. By providing a lightweight representation of the affected object, you get the
/// flexibility of choosing a data storage implementation that works best for your app (e.g.
/// CoreData or Realm) and can use the <code>DisconnectedUser/userId</code> property to aid in lookups.
SWIFT_CLASS_NAMED("DisconnectedUser")
@interface AmazonIVSChatDisconnectedUser : NSObject
/// A unique identifier that matches the <code>ChatUser/userId</code> of a <code>ChatMessage/sender</code>
/// that was attached to a <code>ChatMessage</code> previously received by the room.
@property (nonatomic, readonly, copy) NSString * _Nonnull userId;
/// The request id of the <code>DisconnectUserRequest</code> that was used to disconnect the user
/// associated with <code>DisconnectedUser/userId</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// The reason supplied by the moderator when disconnecting this user.
@property (nonatomic, readonly, copy) NSString * _Nullable reason;
@end

/// A type used to send a message to a chat room.
SWIFT_CLASS_NAMED("SendMessageRequest")
@interface AmazonIVSChatSendMessageRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>SendMessageRequest</code>.
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatMessage</code> being broadcasted to all users currently connected to
/// the chat room. This <code>ChatMessage</code> instance is then broadcasted through the
/// <code>ChatRoomDelegate/room(_:didReceive:)-2zfih</code> function within your <code>ChatRoomDelegate</code>.
/// \param content The main text content of the message you want to send to a chat room.
///
/// \param attributes A <code>String</code> dictionary that you can populate in order to attach metadata
/// to the message you send to a chat room. This <code>String</code> dictionary will be accessible in
/// the resulting <code>ChatMessage</code> that gets broadcasted to the connected chat room. You can
/// use this parameter to build complex chat features (like replies or threading) by
/// attaching metadata to each message using values specific to the complex feature
/// offered by your chat app.
///
- (nonnull instancetype)initWithContent:(NSString * _Nonnull)content attributes:(NSDictionary<NSString *, NSString *> * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#elif defined(__x86_64__) && __x86_64__
// Generated by Apple Swift version 6.1.2 effective-5.10 (swiftlang-6.1.2.1.2 clang-1700.0.13.5)
#ifndef AMAZONIVSCHATMESSAGING_SWIFT_H
#define AMAZONIVSCHATMESSAGING_SWIFT_H
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wgcc-compat"

#if !defined(__has_include)
# define __has_include(x) 0
#endif
#if !defined(__has_attribute)
# define __has_attribute(x) 0
#endif
#if !defined(__has_feature)
# define __has_feature(x) 0
#endif
#if !defined(__has_warning)
# define __has_warning(x) 0
#endif

#if __has_include(<swift/objc-prologue.h>)
# include <swift/objc-prologue.h>
#endif

#pragma clang diagnostic ignored "-Wauto-import"
#if defined(__OBJC__)
#include <Foundation/Foundation.h>
#endif
#if defined(__cplusplus)
#include <cstdint>
#include <cstddef>
#include <cstdbool>
#include <cstring>
#include <stdlib.h>
#include <new>
#include <type_traits>
#else
#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>
#include <string.h>
#endif
#if defined(__cplusplus)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wnon-modular-include-in-framework-module"
#if defined(__arm64e__) && __has_include(<ptrauth.h>)
# include <ptrauth.h>
#else
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wreserved-macro-identifier"
# ifndef __ptrauth_swift_value_witness_function_pointer
#  define __ptrauth_swift_value_witness_function_pointer(x)
# endif
# ifndef __ptrauth_swift_class_method_pointer
#  define __ptrauth_swift_class_method_pointer(x)
# endif
#pragma clang diagnostic pop
#endif
#pragma clang diagnostic pop
#endif

#if !defined(SWIFT_TYPEDEFS)
# define SWIFT_TYPEDEFS 1
# if __has_include(<uchar.h>)
#  include <uchar.h>
# elif !defined(__cplusplus)
typedef unsigned char char8_t;
typedef uint_least16_t char16_t;
typedef uint_least32_t char32_t;
# endif
typedef float swift_float2  __attribute__((__ext_vector_type__(2)));
typedef float swift_float3  __attribute__((__ext_vector_type__(3)));
typedef float swift_float4  __attribute__((__ext_vector_type__(4)));
typedef double swift_double2  __attribute__((__ext_vector_type__(2)));
typedef double swift_double3  __attribute__((__ext_vector_type__(3)));
typedef double swift_double4  __attribute__((__ext_vector_type__(4)));
typedef int swift_int2  __attribute__((__ext_vector_type__(2)));
typedef int swift_int3  __attribute__((__ext_vector_type__(3)));
typedef int swift_int4  __attribute__((__ext_vector_type__(4)));
typedef unsigned int swift_uint2  __attribute__((__ext_vector_type__(2)));
typedef unsigned int swift_uint3  __attribute__((__ext_vector_type__(3)));
typedef unsigned int swift_uint4  __attribute__((__ext_vector_type__(4)));
#endif

#if !defined(SWIFT_PASTE)
# define SWIFT_PASTE_HELPER(x, y) x##y
# define SWIFT_PASTE(x, y) SWIFT_PASTE_HELPER(x, y)
#endif
#if !defined(SWIFT_METATYPE)
# define SWIFT_METATYPE(X) Class
#endif
#if !defined(SWIFT_CLASS_PROPERTY)
# if __has_feature(objc_class_property)
#  define SWIFT_CLASS_PROPERTY(...) __VA_ARGS__
# else
#  define SWIFT_CLASS_PROPERTY(...) 
# endif
#endif
#if !defined(SWIFT_RUNTIME_NAME)
# if __has_attribute(objc_runtime_name)
#  define SWIFT_RUNTIME_NAME(X) __attribute__((objc_runtime_name(X)))
# else
#  define SWIFT_RUNTIME_NAME(X) 
# endif
#endif
#if !defined(SWIFT_COMPILE_NAME)
# if __has_attribute(swift_name)
#  define SWIFT_COMPILE_NAME(X) __attribute__((swift_name(X)))
# else
#  define SWIFT_COMPILE_NAME(X) 
# endif
#endif
#if !defined(SWIFT_METHOD_FAMILY)
# if __has_attribute(objc_method_family)
#  define SWIFT_METHOD_FAMILY(X) __attribute__((objc_method_family(X)))
# else
#  define SWIFT_METHOD_FAMILY(X) 
# endif
#endif
#if !defined(SWIFT_NOESCAPE)
# if __has_attribute(noescape)
#  define SWIFT_NOESCAPE __attribute__((noescape))
# else
#  define SWIFT_NOESCAPE 
# endif
#endif
#if !defined(SWIFT_RELEASES_ARGUMENT)
# if __has_attribute(ns_consumed)
#  define SWIFT_RELEASES_ARGUMENT __attribute__((ns_consumed))
# else
#  define SWIFT_RELEASES_ARGUMENT 
# endif
#endif
#if !defined(SWIFT_WARN_UNUSED_RESULT)
# if __has_attribute(warn_unused_result)
#  define SWIFT_WARN_UNUSED_RESULT __attribute__((warn_unused_result))
# else
#  define SWIFT_WARN_UNUSED_RESULT 
# endif
#endif
#if !defined(SWIFT_NORETURN)
# if __has_attribute(noreturn)
#  define SWIFT_NORETURN __attribute__((noreturn))
# else
#  define SWIFT_NORETURN 
# endif
#endif
#if !defined(SWIFT_CLASS_EXTRA)
# define SWIFT_CLASS_EXTRA 
#endif
#if !defined(SWIFT_PROTOCOL_EXTRA)
# define SWIFT_PROTOCOL_EXTRA 
#endif
#if !defined(SWIFT_ENUM_EXTRA)
# define SWIFT_ENUM_EXTRA 
#endif
#if !defined(SWIFT_CLASS)
# if __has_attribute(objc_subclassing_restricted)
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_subclassing_restricted)) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# else
#  define SWIFT_CLASS(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
#  define SWIFT_CLASS_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_CLASS_EXTRA
# endif
#endif
#if !defined(SWIFT_RESILIENT_CLASS)
# if __has_attribute(objc_class_stub)
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME) __attribute__((objc_class_stub))
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) __attribute__((objc_class_stub)) SWIFT_CLASS_NAMED(SWIFT_NAME)
# else
#  define SWIFT_RESILIENT_CLASS(SWIFT_NAME) SWIFT_CLASS(SWIFT_NAME)
#  define SWIFT_RESILIENT_CLASS_NAMED(SWIFT_NAME) SWIFT_CLASS_NAMED(SWIFT_NAME)
# endif
#endif
#if !defined(SWIFT_PROTOCOL)
# define SWIFT_PROTOCOL(SWIFT_NAME) SWIFT_RUNTIME_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
# define SWIFT_PROTOCOL_NAMED(SWIFT_NAME) SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_PROTOCOL_EXTRA
#endif
#if !defined(SWIFT_EXTENSION)
# define SWIFT_EXTENSION(M) SWIFT_PASTE(M##_Swift_, __LINE__)
#endif
#if !defined(OBJC_DESIGNATED_INITIALIZER)
# if __has_attribute(objc_designated_initializer)
#  define OBJC_DESIGNATED_INITIALIZER __attribute__((objc_designated_initializer))
# else
#  define OBJC_DESIGNATED_INITIALIZER 
# endif
#endif
#if !defined(SWIFT_ENUM_ATTR)
# if __has_attribute(enum_extensibility)
#  define SWIFT_ENUM_ATTR(_extensibility) __attribute__((enum_extensibility(_extensibility)))
# else
#  define SWIFT_ENUM_ATTR(_extensibility) 
# endif
#endif
#if !defined(SWIFT_ENUM)
# define SWIFT_ENUM(_type, _name, _extensibility) enum _name : _type _name; enum SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# if __has_feature(generalized_swift_name)
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) enum _name : _type _name SWIFT_COMPILE_NAME(SWIFT_NAME); enum SWIFT_COMPILE_NAME(SWIFT_NAME) SWIFT_ENUM_ATTR(_extensibility) SWIFT_ENUM_EXTRA _name : _type
# else
#  define SWIFT_ENUM_NAMED(_type, _name, SWIFT_NAME, _extensibility) SWIFT_ENUM(_type, _name, _extensibility)
# endif
#endif
#if !defined(SWIFT_UNAVAILABLE)
# define SWIFT_UNAVAILABLE __attribute__((unavailable))
#endif
#if !defined(SWIFT_UNAVAILABLE_MSG)
# define SWIFT_UNAVAILABLE_MSG(msg) __attribute__((unavailable(msg)))
#endif
#if !defined(SWIFT_AVAILABILITY)
# define SWIFT_AVAILABILITY(plat, ...) __attribute__((availability(plat, __VA_ARGS__)))
#endif
#if !defined(SWIFT_WEAK_IMPORT)
# define SWIFT_WEAK_IMPORT __attribute__((weak_import))
#endif
#if !defined(SWIFT_DEPRECATED)
# define SWIFT_DEPRECATED __attribute__((deprecated))
#endif
#if !defined(SWIFT_DEPRECATED_MSG)
# define SWIFT_DEPRECATED_MSG(...) __attribute__((deprecated(__VA_ARGS__)))
#endif
#if !defined(SWIFT_DEPRECATED_OBJC)
# if __has_feature(attribute_diagnose_if_objc)
#  define SWIFT_DEPRECATED_OBJC(Msg) __attribute__((diagnose_if(1, Msg, "warning")))
# else
#  define SWIFT_DEPRECATED_OBJC(Msg) SWIFT_DEPRECATED_MSG(Msg)
# endif
#endif
#if defined(__OBJC__)
#if !defined(IBSegueAction)
# define IBSegueAction 
#endif
#endif
#if !defined(SWIFT_EXTERN)
# if defined(__cplusplus)
#  define SWIFT_EXTERN extern "C"
# else
#  define SWIFT_EXTERN extern
# endif
#endif
#if !defined(SWIFT_CALL)
# define SWIFT_CALL __attribute__((swiftcall))
#endif
#if !defined(SWIFT_INDIRECT_RESULT)
# define SWIFT_INDIRECT_RESULT __attribute__((swift_indirect_result))
#endif
#if !defined(SWIFT_CONTEXT)
# define SWIFT_CONTEXT __attribute__((swift_context))
#endif
#if !defined(SWIFT_ERROR_RESULT)
# define SWIFT_ERROR_RESULT __attribute__((swift_error_result))
#endif
#if defined(__cplusplus)
# define SWIFT_NOEXCEPT noexcept
#else
# define SWIFT_NOEXCEPT 
#endif
#if !defined(SWIFT_C_INLINE_THUNK)
# if __has_attribute(always_inline)
# if __has_attribute(nodebug)
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline)) __attribute__((nodebug))
# else
#  define SWIFT_C_INLINE_THUNK inline __attribute__((always_inline))
# endif
# else
#  define SWIFT_C_INLINE_THUNK inline
# endif
#endif
#if defined(_WIN32)
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL __declspec(dllimport)
#endif
#else
#if !defined(SWIFT_IMPORT_STDLIB_SYMBOL)
# define SWIFT_IMPORT_STDLIB_SYMBOL 
#endif
#endif
#if defined(__OBJC__)
#if __has_feature(objc_modules)
#if __has_warning("-Watimport-in-framework-header")
#pragma clang diagnostic ignored "-Watimport-in-framework-header"
#endif
@import Foundation;
@import ObjectiveC;
#endif

#endif
#pragma clang diagnostic ignored "-Wproperty-attribute-mismatch"
#pragma clang diagnostic ignored "-Wduplicate-method-arg"
#if __has_warning("-Wpragma-clang-attribute")
# pragma clang diagnostic ignored "-Wpragma-clang-attribute"
#endif
#pragma clang diagnostic ignored "-Wunknown-pragmas"
#pragma clang diagnostic ignored "-Wnullability"
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
#pragma clang diagnostic ignored "-Wunsafe-buffer-usage"

#if __has_attribute(external_source_symbol)
# pragma push_macro("any")
# undef any
# pragma clang attribute push(__attribute__((external_source_symbol(language="Swift", defined_in="AmazonIVSChatMessaging",generated_declaration))), apply_to=any(function,enum,objc_interface,objc_category,objc_protocol))
# pragma pop_macro("any")
#endif

#if defined(__OBJC__)

@class NSString;
enum AmazonIVSChatErrorCode : NSInteger;
/// Error messages are pushed to clients if an operation fails.
/// Due to the asynchronous nature of the Chat messaging API, web socket error messages include an
/// identifier that the client can use to map back to the responsible operation. The SDK already
/// handles this for you and throws these errors matched to the <code>ChatRequest/requestId</code> of the
/// attempted <code>ChatRequest</code> sent to an instance of <code>ChatRoom</code> through the
/// <code>ChatRoom/perform(request:)</code> function.
/// See <a href="https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/error-messages.html">our documentation</a>
/// for more info on different error types that could be thrown by the SDK.
SWIFT_CLASS_NAMED("ChatError")
@interface AmazonIVSChatError : NSObject
/// The server id of the error object.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object that triggered this error.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The error code of this chat error. Each error code is unique and can be used to identify
/// why the request failed. See <code>ChatError/Code</code> for more information on the different codes
/// that can be thrown.
@property (nonatomic, readonly) enum AmazonIVSChatErrorCode errorCode;
/// The message content of the chat error. This content may be populated by the Messaging API
/// itself or the SDK.
@property (nonatomic, readonly, copy) NSString * _Nullable errorMessage;
@property (nonatomic, readonly, copy) NSString * _Nonnull description;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

typedef SWIFT_ENUM_NAMED(NSInteger, AmazonIVSChatErrorCode, "Code", closed) {
/// The request is either malformed, invalid, or the chat message exceeded the character limit (invalid).
  AmazonIVSChatErrorCodeInvalidParameter = 400,
/// The connection has expired.
  AmazonIVSChatErrorCodeUnauthorized = 401,
/// The connection’s capabilities do not permit this action.
  AmazonIVSChatErrorCodeForbidden = 403,
/// Either the room could not be found or a resource referenced/mutated by the operation does not exist.
  AmazonIVSChatErrorCodeResourceNotFound = 404,
/// The request was rejected during message review.
  AmazonIVSChatErrorCodeNotAcceptable = 406,
/// The request contains fields that are too large.
  AmazonIVSChatErrorCodePayloadTooLarge = 413,
/// The application has exceeded rate limits.
  AmazonIVSChatErrorCodeTooManyRequests = 429,
/// Unknown error.
  AmazonIVSChatErrorCodeInternalServerError = 500,
};

@class NSDate;
/// An event broadcasted to the chat room through the Messaging API.
SWIFT_CLASS_NAMED("ChatEvent")
@interface AmazonIVSChatEvent : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull eventName;
/// The server id of the event object broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object that triggered this event in a chat room.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The timestamp of when the event was broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSDate * _Nonnull sendTime;
/// Custom metadata that is supplied by the request object that triggered this event.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
@end

@class AmazonIVSChatUser;
/// A message sent by a user that is connected to the chat room.
SWIFT_CLASS_NAMED("ChatMessage")
@interface AmazonIVSChatMessage : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull content;
@property (nonatomic, readonly, strong) AmazonIVSChatUser * _Nonnull sender;
/// The server id of a message.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
/// The id of the request object used to send this message to a chat room.
@property (nonatomic, readonly, copy) NSString * _Nullable requestId;
/// The timestamp of when the message was broadcasted by the Messaging API.
@property (nonatomic, readonly, copy) NSDate * _Nonnull sendTime;
/// Custom metadata that you supply through the <code>attributes</code> parameter of the
/// <code>SendMessageRequest/init(content:attributes:)</code> initializer for <code>SendMessageRequest</code>.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
@end

@protocol AmazonIVSChatRoomDelegate;
enum AmazonIVSChatRoomState : NSInteger;
@protocol AmazonIVSChatTokenProvider;
@class AmazonIVSChatSendMessageRequest;
@class AmazonIVSChatDeleteMessageRequest;
@class AmazonIVSChatDeletedMessage;
@class AmazonIVSChatDisconnectUserRequest;
@class AmazonIVSChatDisconnectedUser;
/// The representation of an Amazon IVS Chat Room that provides the same functionality that a
/// developer can achieve using the IVS Chat Messaging APIs.
SWIFT_CLASS_NAMED("ChatRoom")
@interface AmazonIVSChatRoom : NSObject
/// The object that acts as the delegate for a <code>ChatRoom</code>.
/// This is the property you want to set if you want to get notifications for events that
/// occur in a chat room (such as messages received or users that were disconnected by another
/// user).
@property (nonatomic, weak) id <AmazonIVSChatRoomDelegate> _Nullable delegate;
/// An observable value that represents the active state of a <code>ChatRoom</code>’s connection.
/// The <code>ChatRoom/state-swift.property</code> property uses Combine’s <code>@Published</code> property wrapper
/// to transmit changes to its value over time. Using Combine, you can observe changes to this
/// property to update your UI accordingly.
/// Below is an example of updating a <code>UIButton</code> that you might use to send messages from a
/// chat room message bar:
/// \code
/// let button = UIButton()
/// let room = ChatRoom(...)
///
/// room.$state.sink { state in
///     switch state {
///     case .connecting, .disconnected:
///         button.isEnabled = false
///     case .connected:
///         button.isEnabled = true
///     }
/// }
///
/// \endcode
@property (nonatomic, readonly) enum AmazonIVSChatRoomState state;
/// Creates an instance of <code>ChatRoom</code> with a <code>tokenProvider</code> that uses delegation to retrieve
/// chat tokens.
/// Since your mobile application is responsible for generating/requesting chat tokens from your
/// backend, this initializer gives you a way to supply the chat token response from your
/// backend to the Chat SDK.
/// \code
/// class MyBackendService: ChatTokenProvider {
///     func getChatToken() async throws -> ChatToken {
///         // call your backend and return a ChatToken here
///         let url = URL(string: "https://api.yourcompany.com/get-chat-token")!
///         var request = URLRequest(url: url)
///         request.httpMethod = "POST"
///         request.httpBody = try JSONEncoder().encode([
///             "userId" : "kraken",
///             "otherParameter" : "some-value"
///         ])
///
///         // Make the request to your backend server app
///         let data = try await URLSession.shared.data(for: request).0
///
///         // Decode the `ChatToken` object from the response of the url request.
///         return try JSONDecoder().decode(ChatToken.self, from: data)
///     }
/// }
///
/// // This is probably something like "us-west-2" or "us-east-1"
/// let awsRegion: String = getAwsRegion()
/// let room = try await ChatRoom(
///     awsRegion: awsRegion,
///     tokenProvider: MyBackendService()
/// )
/// print("💬 Room is connecting!")
/// try await room.connect()
/// print("✅ Room connected!")
///
/// \endcode\param awsRegion The AWS region that your chat room was created in. This might be a single aws
/// region that your backend application creates all chat rooms in, or it might be a dynamic
/// AWS region if your server-side application creates rooms in more than one region.
///
/// \param maxReconnectAttempts An integer representing the maximum amount of times this <code>ChatRoom</code>
/// instance will attempt to reconnect to the socket when something happens that requires a
/// refresh of your <code>ChatToken</code>. The current amount of connect attempts will reset when a
/// successful <code>room.connect()</code> call occurs.
///
/// \param tokenProvider An asynchronous, escaping closure that can be called more than once when
/// the <code>ChatRoom</code> needs a new chat token from your mobile application’s backend. If your
/// mobile application uses Swift’s async/await APIs you can call <code>try await</code> within this
/// closure.
///
- (nonnull instancetype)initWithAwsRegion:(NSString * _Nonnull)awsRegion maxReconnectAttempts:(NSInteger)maxReconnectAttempts tokenProvider:(id <AmazonIVSChatTokenProvider> _Nonnull)tokenProvider;
/// A Swift Async function that attempts to establish a connection with a chat room.
/// To get a valid chat token, the SDK will attempt to call the token provider that you used to
/// initialize this chat room. Once the token fetch has succeeded, it will then use that chat
/// token to authenticate to IVS’ Chat Messaging API by means of opening a web socket.
///
/// throws:
/// The same <code>Swift.Error</code> that your <code>ChatTokenProvider</code> throws during
/// <code>ChatTokenProvider/getChatToken()</code>.
- (void)connectWithCompletionHandler:(void (^ _Nonnull)(NSError * _Nullable))completionHandler;
/// Connects to the chat room, sending a notification of successes or failures in a
/// completion handler.
/// This is functionally equivalent to <code>ChatRoom/connect()</code>. Any errors thrown by that
/// function will be returned as a parameter within the completion handler. If the error is nil,
/// you can assume a successful connection to the chat room.
/// The completion handler passes in the current instance of <code>ChatRoom</code> to assist with follow
/// up actions that you may want to perform on a <code>ChatRoom</code> without having to deal with
/// reference semantics in the context of memory management within the closure’s capture list.
/// \param completion A closure that passes in the current <code>ChatRoom</code> instance with an optional
/// <code>Swift.Error</code> that is populated when the connection fails. The error parameter is nil
/// when connecting successfully.
///
- (void)connect:(void (^ _Nonnull)(AmazonIVSChatRoom * _Nonnull, NSError * _Nullable))completion;
/// Disconnects from the chat room.
/// Calling this function will tear down any currently connected <code>URLSession</code>s or data tasks
/// associated with the room. If the <code>ChatToken</code> you used to authenticate to the chat room
/// has session expiration metadata associated with it, this function will also cancel the
/// internal timer that <code>ChatRoom</code> creates to proactively refresh your token before it
/// expires.
- (void)disconnect;
/// Sends a message to the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>SendMessageRequest</code>s only.
/// \param request An instance of <code>SendMessageRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>ChatMessage</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)sendMessageWithRequest:(AmazonIVSChatSendMessageRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatMessage * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
/// Deletes a message from the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>DeleteMessageRequest</code>s only.
/// \param request An instance of <code>DeleteMessageRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>DeletedMessage</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)deleteMessageWithRequest:(AmazonIVSChatDeleteMessageRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatDeletedMessage * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
/// Disconnects a user from the chat room, receiving the result in a completion handler.
/// This is an <code>@objc</code> compatible version of <code>ChatRoom/perform(request:)</code> that limits
/// the request parameter to <code>DisconnectUserRequest</code>s only.
/// \param request An instance of <code>DisconnectUserRequest</code>.
///
/// \param onSuccess A closure that receives the same instance of <code>DisconnectedUser</code> that other
/// clients connected to the same chat room will receive, including the client that sent the
/// request.
///
/// \param onFailure A closure that receives a <code>ChatError</code> when this request fails to complete.
///
- (void)disconnectUserWithRequest:(AmazonIVSChatDisconnectUserRequest * _Nonnull)request successBlock:(void (^ _Nullable)(AmazonIVSChatDisconnectedUser * _Nonnull))onSuccess failureBlock:(void (^ _Nullable)(AmazonIVSChatError * _Nonnull))onFailure;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// The active state of a <code>ChatRoom</code>’s connection.
typedef SWIFT_ENUM_NAMED(NSInteger, AmazonIVSChatRoomState, "State", closed) {
/// Indicates when a room is connecting to a web socket. Only used during the transition
/// from <code>.disconnected</code> to <code>.connected</code>. This is not set when there is an active
/// connection in a room.
  AmazonIVSChatRoomStateConnecting = 0,
/// Indicates that a room is ready to receive and send messages.
  AmazonIVSChatRoomStateConnected = 1,
/// Indicates that a room is no longer capable of receiving or sending messages.
  AmazonIVSChatRoomStateDisconnected = 2,
};

/// A type that provides hooks into events that occur within a <code>ChatRoom</code> (such as receiving
/// messages or changes to a room’s connection state).
/// To get notified when events within a <code>AmazonIVSChatMessaging/ChatRoom</code> occur, you need to
/// define your own type that conforms to this protocol and implement
/// <code>AmazonIVSChatMessaging/ChatRoomDelegate/room(_:didReceive:)-4zyws</code>:
/// \code
/// import AmazonIVSChatMessaging
/// struct YourChatManager: ChatRoomDelegate {
///     func room(_ room: ChatRoom, didReceive message: ChatMessage) {
///         // Prints the contents of a message that someone sent to this Chat Room
///         print(message.content)
///     }
/// }
///
/// \endcodeAfter you’ve defined a type that conforms to <code>AmazonIVSChatMessaging/ChatRoomDelegate</code>,
/// create an instance of that type and assign it to the <code>AmazonIVSChatMessaging/ChatRoom/delegate</code>
/// property of a <code>AmazonIVSChatMessaging/ChatRoom</code>. This follows the same delegation pattern of
/// common UIKit classes such as <code>UITableView</code> or <code>UIScrollView</code>.
/// \code
/// let delegate = YourChatManager()
/// let room = ChatRoom(...)
///
/// // Assign your delegate before connecting to the room
/// room.delegate = delegate
///
/// // Connect to the chat room to start receiving events
/// try await room.connect()
///
/// \endcode
SWIFT_PROTOCOL_NAMED("ChatRoomDelegate")
@protocol AmazonIVSChatRoomDelegate
/// Notifies when a message is received in a chat room.
/// This is the only function required by <code>ChatRoomDelegate</code> when conforming to it. It is
/// typically called when the chat room’s web socket receives a JSON payload that maps directly
/// to the properties found in <code>ChatMessage</code>. This is specifically determined by the value of
/// the “type” field in that JSON payload - the value in this case would be “MESSAGE”.
/// \param room The instance of the room that this message was received in.
///
/// \param message The message that was received.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didReceiveMessage:(AmazonIVSChatMessage * _Nonnull)message;
@optional
/// Notifies when special events (such as system events or custom client-defined events) are
/// received by a chat room.
/// This function is typically called when the chat room’s web socket receives a JSON payload
/// that maps directly to the properties found in <code>ChatEvent</code>. This is specifically determined
/// by the value of the “type” field in that JSON payload - the value in this case would be “EVENT”.
/// IVS Chat also defines system events for common actions that occur in a chat room such as
/// messages being deleted or users that get disconnected by a moderator in the room. These
/// system events can be identified by inspecting the event’s <code>ChatEvent/eventName</code> property.
/// All system events sent by IVS will prefix the <code>ChatEvent/eventName</code> value with “aws:”.
/// \param room The instance of the room that this event was received in.
///
/// \param event The event that was received.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didReceiveEvent:(AmazonIVSChatEvent * _Nonnull)event;
/// A system event defined by IVS Chat that represents when a message is deleted by a user
/// in a chat room.
/// When a chat room receives this system event, a specialized payload gets attached to the
/// <code>ChatEvent/attributes</code> property of an underlying <code>ChatEvent</code> instance. The SDK then
/// serializes that payload into an instance of <code>DeletedMessage</code> and passes it into
/// this function. If this serialization fails, the SDK has a fallback that will call the
/// <code>ChatRoomDelegate/room(_:didReceive:)-4zyws</code> function instead.
/// \param room The instance of the room this message was deleted in.
///
/// \param message A class that contains the id of the deleted message as well as the reason for
/// that message getting deleted.
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didDeleteMessage:(AmazonIVSChatDeletedMessage * _Nonnull)message;
/// A system event defined by IVS Chat that represents when a user is disconnected by another
/// user (typically a moderator) in a chat room.
/// When a chat room receives this system event, a specialized payload gets attached to the
/// <code>ChatEvent/attributes</code> property of an underlying <code>ChatEvent</code> instance. The SDK then
/// serializes that payload into an instance of <code>DisconnectedUser</code> and passes it into
/// this function. If this serialization fails, the SDK has a fallback that will call the
/// <code>ChatRoomDelegate/room(_:didReceive:)-4zyws</code> function instead.
/// \param room The instance of the room this user was disconnected from.
///
/// \param user A class that contains the id of the disconnected user as well as the reason for
/// that user getting disconnected (typically due to some sort of moderation action).
///
- (void)room:(AmazonIVSChatRoom * _Nonnull)room didDisconnectUser:(AmazonIVSChatDisconnectedUser * _Nonnull)user;
/// A lifecycle event that represents when a <code>ChatRoom</code> has successfully connected and can
/// receive/send messages.
/// Calling <code>ChatRoom/connect()</code> on a <code>ChatRoom</code> instance does not automatically call this
/// function. The room waits for a successful web socket connection before determining whether
/// or not it has been connected. You can assume that this callback will only occur when you can
/// successfully start sending requests to a chat room.
/// \param room The instance of the room that successfully connected.
///
- (void)roomDidConnect:(AmazonIVSChatRoom * _Nonnull)room;
/// A lifecycle event that represents when a fully disconnected <code>ChatRoom</code> is attempting to
/// connect.
/// Calling <code>ChatRoom/connect()</code> on a <code>ChatRoom</code> instance does not automatically call this
/// function. A <code>ChatToken</code> may still be valid for a chat room when calling
/// <code>ChatRoom/connect()</code> which means your room may still be connected. This callback should
/// only occur when a room is completely disconnected and not capable of receiving or
/// sending messages.
/// \param room The instance of the room that is currently connecting.
///
- (void)roomIsConnecting:(AmazonIVSChatRoom * _Nonnull)room;
/// A lifecycle event that represents when a <code>ChatRoom</code> is no longer able to receive or send
/// messages.
/// Calling <code>ChatRoom/disconnect()</code> on a <code>ChatRoom</code> instance will automatically call this
/// function after making tear down calls to the underlying <code>URLSession</code>. This callback will
/// only occur when a room is either currently connected or trying to connect to the underlying
/// web socket and the user calls <code>ChatRoom/disconnect()</code>.
/// \param room The instance of the room that is currently connecting.
///
- (void)roomDidDisconnect:(AmazonIVSChatRoom * _Nonnull)room;
@end

/// A representation of the <code>CreateChatToken</code> response payload from the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/Welcome.html">AWS IVS Chat API
/// </a>.
/// By default, all you need is the token string returned by your server-side application to
/// effectively initialize an instance of <code>ChatRoom</code>. However, you can provide additional
/// information (also provided by your backend) that instances of <code>ChatRoom</code> use to provide sensible
/// default behavior throughout the course of your chat session.
/// The order in which token authentication occurs is as follows:
/// <ol>
///   <li>
///     Your chat app makes a URL request to your server-side application to initiate the
///     token creation flow. This is typically done through an object that conforms to
///     <code>ChatTokenProvider</code> within the body of the <code>ChatTokenProvider/getChatToken()</code> function.
///   </li>
///   <li>
///     Your server-side application then makes a POST request to the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken endpoint
///     </a>
///     from the IVS Chat Control Plane API.
///   </li>
///   <li>
///     Using the response from the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken endpoint
///     </a>, your
///     server-side application will then forward that payload in its response to your chat app. Your
///     chat app will use this payload to create an instance of <code>ChatToken</code> and return that token
///     instance in its implementation of <code>ChatTokenProvider/getChatToken()</code>.
///   </li>
///   <li>
///     An instance of <code>ChatRoom</code> will then use that <code>ChatTokenProvider</code> to query for chat tokens
///     at the appropriate times (such as when your session is about to expire or when the room needs
///     to connect for the first time).
///   </li>
/// </ol>
SWIFT_CLASS_NAMED("ChatToken")
@interface AmazonIVSChatToken : NSObject
/// Creates an instance of <code>ChatToken</code>
/// \param token The encrypted token string returned by your server-side application.
///
/// \param tokenExpirationTime The date by which the token should be used to authenticate to a
/// chat room.
///
/// \param sessionExpirationTime The date by which the token should be refreshed by the chat
/// room. This is when your chat session will expire.
///
- (nonnull instancetype)initWithToken:(NSString * _Nonnull)token tokenExpirationTime:(NSDate * _Nullable)tokenExpirationTime sessionExpirationTime:(NSDate * _Nullable)sessionExpirationTime OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A type that provides a chat token that can be used to successfully authenticate to a chat room.
/// Chat token providers are how your <code>ChatRoom</code> instances delegate the retrieval of encrypted
/// chat tokens from your server-side application. Your chat app is responsible for assigning
/// a provider to a chat room through its initializers.
SWIFT_PROTOCOL_NAMED("ChatTokenProvider")
@protocol AmazonIVSChatTokenProvider
/// Queries your server-side application for a chat token when an instance of <code>ChatRoom</code>
/// requires authentication.
///
/// returns:
/// An instance of a <code>ChatToken</code> that is used to authenticate to our Messaging API.
/// This token provides the encrypted token value as well as additional information that
/// <code>ChatRoom</code> instances can use to gracefully refresh a chat session before it expires.
- (void)getChatTokenWithCompletionHandler:(void (^ _Nonnull)(AmazonIVSChatToken * _Nullable, NSError * _Nullable))completionHandler;
@end

/// The representation of a user in the chat room.
/// This is typically deserialized from the <code>ChatMessage/sender</code> property of a
/// <code>ChatMessage</code> received by the chat room.
SWIFT_CLASS_NAMED("ChatUser")
@interface AmazonIVSChatUser : NSObject
/// A unique identifier for this user. This is typically the value needed for initializing a
/// valid <code>DisconnectUserRequest</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull userId;
/// Metadata that directly correlates to the data passed by your server application when making
/// calls to the <a href="https://docs.aws.amazon.com/ivs/latest/ChatAPIReference/API_CreateChatToken.html">/CreateChatToken API</a>.
@property (nonatomic, readonly, copy) NSDictionary<NSString *, NSString *> * _Nullable attributes;
/// A property that provides conformance to the <code>Identifiable</code> protocol. The underlying value
/// is the same as the value for <code>ChatUser/userId</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull id;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A type used to delete an existing message from a chat room.
SWIFT_CLASS_NAMED("DeleteMessageRequest")
@interface AmazonIVSChatDeleteMessageRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>DeleteMessageRequest</code>.
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatEvent</code> being broadcasted to all users currently connected to
/// the chat room. This event is parsed and converted into a <code>DeletedMessage</code> instance
/// that gets sent through the <code>ChatRoomDelegate/room(_:didDelete:)</code> function within your
/// <code>ChatRoomDelegate</code>.
/// \param id The server id of the <code>ChatMessage</code> you want to delete.
///
/// \param reason A <code>String</code> used to indicate the reason for deleting this message. You can
/// leverage this value in your UI to notify your users why a specific message was deleted.
///
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id reason:(NSString * _Nullable)reason OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A lightweight representation of a <code>ChatMessage</code> that was deleted by a moderator in a chat
/// room.
/// The Messaging SDK will not make any assumptions about how you persist the data you receive from
/// a chat room. By providing a lightweight representation of the affected object, you get the
/// flexibility of choosing a data storage implementation that works best for your app (e.g.
/// CoreData or Realm) and can use the <code>DeletedMessage/messageID</code> property to aid in lookups.
SWIFT_CLASS_NAMED("DeletedMessage")
@interface AmazonIVSChatDeletedMessage : NSObject
/// A unique identifier that matches the <code>id</code> value of a <code>ChatMessage</code> instance that was
/// previously received by a <code>ChatRoom</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull messageID;
/// The request id of the <code>DeleteMessageRequest</code> that was used to delete the message
/// associated with <code>DeletedMessage/messageID</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// The reason supplied by the moderator when deleting this message.
@property (nonatomic, readonly, copy) NSString * _Nullable reason;
@end

/// A type used to disconnect another user from a chat room.
SWIFT_CLASS_NAMED("DisconnectUserRequest")
@interface AmazonIVSChatDisconnectUserRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>DisconnectUserRequest</code>.
/// This request is solely meant to sever the web socket connection of another connected user.
/// If you are trying to implement a ban-like feature in your chat app, you need to make sure
/// that you persist that user as “banned” within your server-side application. If you don’t do
/// this, a disconnected user can easily reconnect to the chat room by requesting another token
/// from that same server-side application.
/// The Amazon IVS Messaging API is a stateless API, therefore it does not keep track of user
/// state on your behalf. Most clients will already have a concept of an identity system within
/// their own server-side applications, so the Messaging API relies on your server-side app to
/// manage authentication through a token-based authentication system (refer to the reference
/// documentation for <code>ChatToken</code> for more information).
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatEvent</code> being broadcasted to all users currently connected to
/// the chat room (including the user being disconnected). This event is parsed and converted
/// into a <code>DisconnectedUser</code> instance that gets sent through the
/// <code>ChatRoomDelegate/room(_:didDisconnect:)</code> function within your <code>ChatRoomDelegate</code>.
/// \param id The server id of the <code>ChatMessage/sender</code> model that is attached to an instance
/// of a <code>ChatMessage</code> that was previously sent to a chat room.
///
/// \param reason A <code>String</code> used to indicate the reason for disconnecting this user. You can
/// leverage this value in your UI to notify your users why a specific user was disconnected.
/// A common use case might be to show other users why another user was banned from a room.
///
- (nonnull instancetype)initWithId:(NSString * _Nonnull)id reason:(NSString * _Nullable)reason OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

/// A lightweight representation of a <code>ChatUser</code> that was disconnected by a moderator in a chat
/// room.
/// The Messaging SDK will not make any assumptions about how you persist the data you receive from
/// a chat room. By providing a lightweight representation of the affected object, you get the
/// flexibility of choosing a data storage implementation that works best for your app (e.g.
/// CoreData or Realm) and can use the <code>DisconnectedUser/userId</code> property to aid in lookups.
SWIFT_CLASS_NAMED("DisconnectedUser")
@interface AmazonIVSChatDisconnectedUser : NSObject
/// A unique identifier that matches the <code>ChatUser/userId</code> of a <code>ChatMessage/sender</code>
/// that was attached to a <code>ChatMessage</code> previously received by the room.
@property (nonatomic, readonly, copy) NSString * _Nonnull userId;
/// The request id of the <code>DisconnectUserRequest</code> that was used to disconnect the user
/// associated with <code>DisconnectedUser/userId</code>.
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// The reason supplied by the moderator when disconnecting this user.
@property (nonatomic, readonly, copy) NSString * _Nullable reason;
@end

/// A type used to send a message to a chat room.
SWIFT_CLASS_NAMED("SendMessageRequest")
@interface AmazonIVSChatSendMessageRequest : NSObject
@property (nonatomic, readonly, copy) NSString * _Nonnull action;
@property (nonatomic, readonly, copy) NSString * _Nonnull requestId;
/// Creates an instance of <code>SendMessageRequest</code>.
/// Sending this request to a <code>ChatRoom</code> using the <code>ChatRoom/perform(request:)</code> function
/// will result in a <code>ChatMessage</code> being broadcasted to all users currently connected to
/// the chat room. This <code>ChatMessage</code> instance is then broadcasted through the
/// <code>ChatRoomDelegate/room(_:didReceive:)-2zfih</code> function within your <code>ChatRoomDelegate</code>.
/// \param content The main text content of the message you want to send to a chat room.
///
/// \param attributes A <code>String</code> dictionary that you can populate in order to attach metadata
/// to the message you send to a chat room. This <code>String</code> dictionary will be accessible in
/// the resulting <code>ChatMessage</code> that gets broadcasted to the connected chat room. You can
/// use this parameter to build complex chat features (like replies or threading) by
/// attaching metadata to each message using values specific to the complex feature
/// offered by your chat app.
///
- (nonnull instancetype)initWithContent:(NSString * _Nonnull)content attributes:(NSDictionary<NSString *, NSString *> * _Nonnull)attributes OBJC_DESIGNATED_INITIALIZER;
- (nonnull instancetype)init SWIFT_UNAVAILABLE;
+ (nonnull instancetype)new SWIFT_UNAVAILABLE_MSG("-init is unavailable");
@end

#endif
#if __has_attribute(external_source_symbol)
# pragma clang attribute pop
#endif
#if defined(__cplusplus)
#endif
#pragma clang diagnostic pop
#endif

#else
#error unsupported Swift architecture
#endif
